def evaluate_subtasks(n, angles=None, results=None):


    subtasks = {
        1: {"points": 5, "condition": lambda x: x <= 2, "depends": [], "info": "баллы"},
        2: {"points": 12, "condition": lambda a: check_angles(a, [0, 90]), "depends": [], "info": "первая ошибка"},
        3: {"points": 10, "condition": lambda a: check_angles(a, [45, 135]), "depends": [], "info": "первая ошибка"},
        4: {"points": 23, "condition": lambda x: x <= 200 and (x**3) <= 3e6, "depends": [], "info": "баллы"},
        5: {"points": 10, "condition": lambda x: x <= 1000 and (x**2) <= 3e7, "depends": [], "info": "баллы"},
        6: {"points": 15, "condition": lambda x: x <= 5000 and (x**2) <= 5e7, "depends": [4, 5], "info": "первая ошибка"},
        7: {"points": 25, "condition": lambda x: x <= 4e5, "depends": [1, 6], "info": "первая ошибка"}
    }

    scores = {}

    for subtask_id in range(1, 8):

        if not all(results.get(dep, False) for dep in subtasks[subtask_id]["depends"]):
            scores[subtask_id] = 0
            continue


        if subtask_id in [2, 3]:
            if subtasks[subtask_id]["condition"](angles):
                scores[subtask_id] = subtasks[subtask_id]["points"]
            else:
                scores[subtask_id] = 0
        else:
            if subtasks[subtask_id]["condition"](n):
                scores[subtask_id] = subtasks[subtask_id]["points"]
            else:
                scores[subtask_id] = 0


    total_score = sum(scores.values())

    return scores, total_score


def check_angles(angles, valid_angles):

    return all(angle in valid_angles for angle in angles)



if __name__ == "__main__":

    n = 150
    angles = [45, 135, 45]
    results = {1: True, 2: True, 3: True, 4: True, 5: True, 6: True}  

    scores, total = evaluate_subtasks(n, angles, results)

    print("Баллы за подзадачи:")
    for i in range(1, 8):
        print(f"Подзадача {i}: {scores[i]} баллов")

    print(f"Итоговый балл: {total}")
