import math

def build_smallest_prime_factor_table(limit):
    spf = list(range(limit + 1))
    for num in range(2, int(math.isqrt(limit)) + 1):
        if spf[num] == num:
            for multiple in range(num * num, limit + 1, num):
                if spf[multiple] == multiple:
                    spf[multiple] = num
    return spf

def check_all_exponents_odd(value, spf_table):
    if value == 1:
        return True
    current = value
    while current > 1:
        prime = spf_table[current]
        exponent = 0
        while current % prime == 0:
            current //= prime
            exponent += 1
        if exponent % 2 == 0:
            return False
    return True

target_count = int(input())
left_bound, right_bound = map(int, input().split())

MAX_VALUE = 10**6
smallest_prime_factors = build_smallest_prime_factor_table(MAX_VALUE)
exponent_parity_flags = [
    check_all_exponents_odd(i, smallest_prime_factors)
    for i in range(MAX_VALUE + 1)
]

sequence_length = 0
result_start = -1

for position in range(left_bound, right_bound + 1):
    if exponent_parity_flags[position]:
        sequence_length += 1
        if sequence_length == target_count:
            result_start = position - target_count + 1
            break
    else:
        sequence_length = 0

if result_start == -1:
    print(-1)
else:
    print(' '.join(map(str, range(result_start, result_start + target_count))))
