def compute_filtered_entity_tally(upper_threshold):

    modular_matches = upper_threshold // 7

    terminal_matches = (upper_threshold + 3) // 10

    compound_matches = 0
    search_step = 70
    candidate = 7 
    while candidate <= upper_threshold:
        if candidate % 10 == 7:
            compound_matches += 1
        candidate += search_step
    return modular_matches + terminal_matches - compound_matches


def discover_target_entity(sequence_index):
    exploration_low = 1
    exploration_high = sequence_index * 10
    while exploration_low < exploration_high:
        exploration_mid = (exploration_low + exploration_high) // 2
        current_tally = compute_filtered_entity_tally(exploration_mid)
        if current_tally < sequence_index:
            exploration_low = exploration_mid + 1
        else:
            exploration_high = exploration_mid
    return exploration_low


def main():
    user_input = int(input())
    result = discover_target_entity(user_input)
    print(result)


if __name__ == "__main__":
    main()
