import math

def normalize_angle(a):
    a = a % math.pi
    if a < 0:
        a += math.pi
    return a

def proj_min_max(rect, c, s):
    x1,y1,x2,y2 = rect
    v1 = x1*c + y1*s
    v2 = x1*c + y2*s
    v3 = x2*c + y1*s
    v4 = x2*c + y2*s
    mn = v1
    if v2 < mn: mn = v2
    if v3 < mn: mn = v3
    if v4 < mn: mn = v4
    mx = v1
    if v2 > mx: mx = v2
    if v3 > mx: mx = v3
    if v4 > mx: mx = v4
    return mn, mx

def exists_line(rects):
    angles_set = set()
    for x1,y1,x2,y2 in rects:
        corners = [(x1,y1),(x1,y2),(x2,y1),(x2,y2)]
        for i in range(4):
            for j in range(i+1,4):
                dx = corners[i][0] - corners[j][0]
                dy = corners[i][1] - corners[j][1]
                ang = math.atan2(-dx, dy)
                ang = normalize_angle(ang)
                angles_set.add(ang)
    if not angles_set:
        return True
    angles = sorted(angles_set)
    angles.append(angles[0] + math.pi)
    mids = [(angles[i] + angles[i+1]) / 2.0 for i in range(len(angles)-1)]
    eps = 1e-12
    for mid in mids:
        c = math.cos(mid); s = math.sin(mid)
        max_min = -1e300
        min_max = 1e300
        for rect in rects:
            mn, mx = proj_min_max(rect, c, s)
            if mn > max_min: max_min = mn
            if mx < min_max: min_max = mx
            if max_min <= min_max + eps:
                return True
    return False

T = int(input().strip())
out = []
for _ in range(T):
    n = int(input().strip())
    rects = [tuple(map(int, input().split())) for _ in range(n)]
    out.append("Yes" if exists_line(rects) else "No")
print("\n".join(out))
