from math import atan2, pi
def convex_hull(points):
    pts = sorted(set(points))
    if len(pts) <= 1:
        return pts
    def cross(o,a,b):
        return (a[0]-o[0])*(b[1]-o[1]) - (a[1]-o[1])*(b[0]-o[0])
    lower=[]
    for p in pts:
        while len(lower)>=2 and cross(lower[-2], lower[-1], p) <= 0:
            lower.pop()
        lower.append(p)
    upper=[]
    for p in reversed(pts):
        while len(upper)>=2 and cross(upper[-2], upper[-1], p) <= 0:
            upper.pop()
        upper.append(p)
    return lower[:-1] + upper[:-1]
def minkowski_sum(h1, h2):
    if not h1 or not h2:
        return []
    if len(h1) == 1 and len(h2) == 1:
        return [(h1[0][0]+h2[0][0], h1[0][1]+h2[0][1])]
    def idx_min(h):
        mi=0
        for i in range(1,len(h)):
            if h[i][0]<h[mi][0] or (h[i][0]==h[mi][0] and h[i][1]<h[mi][1]):
                mi=i
        return mi
    n1=len(h1); n2=len(h2)
    i1=idx_min(h1); i2=idx_min(h2)
    e1=[(h1[(i+1)%n1][0]-h1[i][0], h1[(i+1)%n1][1]-h1[i][1]) for i in range(n1)]
    e2=[(h2[(i+1)%n2][0]-h2[i][0], h2[(i+1)%n2][1]-h2[i][1]) for i in range(n2)]
    i=j=0
    curx = h1[i1][0]+h2[i2][0]; cury = h1[i1][1]+h2[i2][1]
    res=[(curx,cury)]
    while i < n1 or j < n2:
        if j>=n2:
            ei = e1[(i1+i)%n1]
            curx += ei[0]; cury += ei[1]; i+=1
        elif i>=n1:
            ej = e2[(i2+j)%n2]
            curx += ej[0]; cury += ej[1]; j+=1
        else:
            ei = e1[(i1+i)%n1]; ej = e2[(i2+j)%n2]
            if ei[0]*ej[1] - ei[1]*ej[0] > 0:
                curx += ei[0]; cury += ei[1]; i+=1
            else:
                curx += ej[0]; cury += ej[1]; j+=1
        res.append((curx,cury))
    if len(res)>1 and abs(res[-1][0]-res[0][0])<1e-12 and abs(res[-1][1]-res[0][1])<1e-12:
        res.pop()
    return res
def exists_line(rects):
    INF = 10**30
    xs0=-INF; xs1=INF; ys0=-INF; ys1=INF
    for x1,y1,x2,y2 in rects:
        if x1>xs0: xs0=x1
        if x2<xs1: xs1=x2
        if y1>ys0: ys0=y1
        if y2<ys1: ys1=y2
    if xs0<=xs1 or ys0<=ys1:
        return True
    quads = [
        (lambda r:(r[0], r[1]), lambda r:(r[2], r[3]), 0.0, pi/2),
        (lambda r:(r[2], r[1]), lambda r:(r[0], r[3]), pi/2, pi),
        (lambda r:(r[2], r[3]), lambda r:(r[0], r[1]), pi, 3*pi/2),
        (lambda r:(r[0], r[3]), lambda r:(r[2], r[1]), 3*pi/2, 2*pi)
    ]
    for fA, fC, th0, th1 in quads:
        A=[fA(r) for r in rects]
        C=[fC(r) for r in rects]
        hullA=convex_hull(A)
        hullC=convex_hull(C)
        negC=[(-p[0], -p[1]) for p in hullC]
        P = minkowski_sum(hullA, negC)
        if not P:
            continue
        def norm(a):
            two=2*pi
            a = a % two
            if a<0: a+=two
            return a
        S_s = norm(atan2(P[0][1], P[0][0]) + pi/2)
        S_e = S_s + pi
        ok=True
        for v in P[1:]:
            si = norm(atan2(v[1], v[0]) + pi/2)
            found=False
            for t in (0.0, 2*pi):
                ns = S_s if S_s>si+t else si+t
                ne = S_e if S_e<si+t+pi else si+t+pi
                if ne + 1e-12 >= ns:
                    S_s=ns; S_e=ne; found=True; break
            if not found:
                ok=False; break
        if not ok:
            continue
        for t in (0.0, 2*pi):
            if min(S_e, th1 + t) + 1e-12 >= max(S_s, th0 + t):
                return True
    return False
T = int(input().strip())
res=[]
for _ in range(T):
    n = int(input().strip())
    rects=[]
    for _ in range(n):
        x1,y1,x2,y2 = map(int, input().split())
        rects.append((x1,y1,x2,y2))
    res.append("Yes" if exists_line(rects) else "No")
print("\n".join(res))
