import math

eps = 1e-12
T = int(input())
for _ in range(T):
    n = int(input())
    rects = [tuple(map(int, input().split())) for __ in range(n)]
    xs1 = [x1 for x1, y1, x2, y2 in rects]
    xs2 = [x2 for x1, y1, x2, y2 in rects]
    ys1 = [y1 for x1, y1, x2, y2 in rects]
    ys2 = [y2 for x1, y1, x2, y2 in rects]

    if max(xs1) <= min(xs2):
        print("Yes")
        continue
    if max(ys1) <= min(ys2):
        print("Yes")
        continue

    found = False
    S = 360
    for t in range(S):
        phi = math.pi * t / S
        c = math.cos(phi)
        s = math.sin(phi)
        curL = -1e300
        curU = 1e300
        ok = True
        for x1, y1, x2, y2 in rects:
            p1 = x1 * c + y1 * s
            p2 = x1 * c + y2 * s
            p3 = x2 * c + y1 * s
            p4 = x2 * c + y2 * s
            mn = min(p1, p2, p3, p4)
            mx = max(p1, p2, p3, p4)
            if mn > curL: curL = mn
            if mx < curU: curU = mx
            if curL - curU > eps:
                ok = False
                break

        if ok and curL - curU <= eps:
            found = True
            break

    print("Yes" if found else "No")