import sys

sys.setrecursionlimit(2000)

def solve():
    try:
        input_line_1 = sys.stdin.readline()
        if not input_line_1:
            return
        segment_length = int(input_line_1)

        input_line_2 = sys.stdin.readline()
        if not input_line_2:
            return
        left_bound, right_bound = map(int, input_line_2.split())
    except ValueError:
        return

    upper_limit = right_bound + 1

    smallest_prime_factor = [0] * upper_limit
    prime_numbers = []

    auxiliary = [1] * upper_limit
    exponent_count = [0] * upper_limit
    is_valid = [False] * upper_limit

    is_valid[1] = True

    for number in range(2, upper_limit):
        if smallest_prime_factor[number] == 0:
            smallest_prime_factor[number] = number
            prime_numbers.append(number)
            exponent_count[number] = 1
            auxiliary[number] = 1
            is_valid[number] = True

        for prime in prime_numbers:
            if prime > smallest_prime_factor[number] or number * prime >= upper_limit:
                break

            product = number * prime
            smallest_prime_factor[product] = prime

            if prime == smallest_prime_factor[number]:
                exponent_count[product] = exponent_count[number] + 1
                auxiliary[product] = auxiliary[number]
                if (exponent_count[product] & 1) and is_valid[auxiliary[product]]:
                    is_valid[product] = True
                else:
                    is_valid[product] = False
            else:
                exponent_count[product] = 1
                auxiliary[product] = number
                is_valid[product] = is_valid[number]

    prefix_sum = [0] * (upper_limit + 1)
    for index in range(1, upper_limit):
        prefix_sum[index] = prefix_sum[index - 1] + (1 if is_valid[index] else 0)

    for start in range(left_bound, right_bound - segment_length + 2):
        end = start + segment_length - 1
        count_of_valid_numbers = prefix_sum[end] - prefix_sum[start - 1]

        if count_of_valid_numbers == segment_length:
            print(*(range(start, end + 1)))
            return

    print("-1")

if __name__ == '__main__':
    solve()
