#include <bits/stdc++.h>

#include <random>
#include <ext/pb_ds/assoc_container.hpp>

using namespace __gnu_pbds;
gp_hash_table<long long, int> table;

using namespace std;
using ll = long long;
using ld = long double;
vector<vector<ll>> g1, g2;
vector<ll> used, pref1, pref2;
gp_hash_table<vector<ll>, ll> mp;

void dfs(ll v, vector<vector<ll>> &g, vector<ll> &pref) {
    used[v] = 1;
    pref[v] = 1;
    for (auto to: g[v]) {
        if (used[to] == 1)continue;
        dfs(to, g, pref);
        pref[v] += pref[to];
    }
}


ll find_centroid(ll v, vector<vector<ll>> &g, vector<ll> &pref) {
    used[v] = 1;
    for (auto to: g[v]) {
        if (used[to] == 1)continue;
        if (pref[to] > (ll) g.size() / 2) {
            return find_centroid(to, g, pref);
        }
    }
    return v;
}


ll hs(ll v, vector<vector<ll>> &g) {
    used[v] = 1;
    vector<ll> k;
    for (auto to: g[v]) {
        if (used[to] == 1) continue;
        hs(to, g);
        k.push_back(to);
    }
    if (!k.empty()) std::sort(k.begin(), k.end());
    if (mp[k] == 0) {
        mp[k] = mp.size();
    }
    return mp[k];
}


int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    ll n;
    cin >> n;
    pref1.assign(n, 0);
    pref2.assign(n, 0);
    g1.assign(n, {});
    g2.assign(n, {});
    for (ll i = 0; i < n; i++) {
        ll a, b;
        cin >> a >> b;
        a--;
        b--;
        g1[a].push_back(b);
        g1[b].push_back(a);
    }
    for (ll i = 0; i < n; i++) {
        ll a, b;
        cin >> a >> b;
        a--;
        b--;
        g2[a].push_back(b);
        g2[b].push_back(a);
    }
    used.assign(n, 0);
    dfs(0, g1, pref1);
    used.assign(n, 0);
    dfs(0, g2, pref2);
    used.assign(n, 0);
    ll c11 = find_centroid(0, g1, pref1);
    used.assign(n, 0);
    ll c21 = find_centroid(0, g2, pref2);
    ll c12 = -1;
    ll c22 = -1;
    for (auto to: g1[c11]) {
        if (pref1[to] * 2 == (ll) g1.size()) {
            c12 = to;
            break;
        }
    }
    for (auto to: g2[c21]) {
        if (pref2[to] * 2 == (ll) g2.size()) {
            c22 = to;
            break;
        }
    }

    vector<ll> p1;
    vector<ll> p2;
    p1.push_back(c11);
    p2.push_back(c21);
    if (c12 != -1) {
        p1.push_back(c12);
    }
    if (c22 != -1) {
        p2.push_back(c22);
    }
    for (ll i = 0; i < (ll) p1.size(); i++) {
        for (ll j = 0; j < (ll) p2.size(); j++) {
            used.assign(n, 0);
            ll b1 = hs(p1[i], g1);
            used.assign(n, 0);
            ll b2 = hs(p2[j], g2);
            if (b1 == b2) {
                cout << "YES" << endl;
                return 0;
            }
        }
    }
    cout << "NO" << endl;
}