import sys

def intersect_intervals(intervals):
    """Возвращает пересечение отрезков [l, r] или None, если оно пусто."""
    if not intervals:
        return None
    left = max(l for l, r in intervals)
    right = min(r for l, r in intervals)
    if left <= right:
        return (left, right)
    return None

def solve_one_test(n, rects):
    # Проверка горизонтальных прямых
    y_intervals = [(y1, y2) for x1, y1, x2, y2 in rects]
    if intersect_intervals(y_intervals) is not None:
        return "Yes"

    # Проверка вертикальных прямых
    x_intervals = [(x1, x2) for x1, y1, x2, y2 in rects]
    if intersect_intervals(x_intervals) is not None:
        return "Yes"

    # Проверка прямых под углом 45° (нормаль (1,1))
    intervals_45 = [(x1 + y1, x2 + y2) for x1, y1, x2, y2 in rects]
    if intersect_intervals(intervals_45) is not None:
        return "Yes"

    # Проверка прямых под углом 135° (нормаль (1,-1))
    intervals_135 = [(x1 - y2, x2 - y1) for x1, y1, x2, y2 in rects]
    if intersect_intervals(intervals_135) is not None:
        return "Yes"

    # Если ни одна проверка не прошла
    return "No"

def main():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    it = iter(data)
    t = int(next(it))
    out_lines = []
    for _ in range(t):
        n = int(next(it))
        rects = []
        for i in range(n):
            x1 = int(next(it)); y1 = int(next(it))
            x2 = int(next(it)); y2 = int(next(it))
            rects.append((x1, y1, x2, y2))
        out_lines.append(solve_one_test(n, rects))
    sys.stdout.write("\n".join(out_lines))

if __name__ == "__main__":
    main()
