import sys

def solve():
    # Читаем две строки обычным способом
    input = sys.stdin.readline

    # Читаем n, K
    line = input()
    while line and line.strip() == '':
        line = input()
    if not line:
        return

    n, K = map(int, line.split())

    # Читаем число R
    S = input().strip()

    MOD = 10**9 + 7

    # Если R = 0
    if S == '0':
        print(1)  # только число 0
        return

    # Преобразуем в бинарную строку
    R = int(S)
    bin_str = bin(R)[2:]
    bits = [int(c) for c in bin_str]
    L = len(bits)

    # DP: dp_tight[mod], dp_not_tight[mod]
    dp_tight = [0] * K
    dp_not_tight = [0] * K
    dp_tight[0] = 1  # начальное состояние

    for i in range(L):
        new_tight = [0] * K
        new_not_tight = [0] * K

        current_bit = bits[i]

        # Обрабатываем not_tight состояния
        for mod in range(K):
            val = dp_not_tight[mod]
            if val:
                # Ставим 0
                new_not_tight[mod] = (new_not_tight[mod] + val) % MOD
                # Ставим 1
                new_mod = mod + 1
                if new_mod >= K:
                    new_mod -= K
                new_not_tight[new_mod] = (new_not_tight[new_mod] + val) % MOD

        # Обрабатываем tight состояния
        for mod in range(K):
            val = dp_tight[mod]
            if not val:
                continue

            if current_bit == 0:
                # Можно поставить только 0
                new_tight[mod] = (new_tight[mod] + val) % MOD
            else:  # current_bit == 1
                # Ставим 0 -> перестаем быть tight
                new_not_tight[mod] = (new_not_tight[mod] + val) % MOD
                # Ставим 1 -> остаемся tight
                new_mod = mod + 1
                if new_mod >= K:
                    new_mod -= K
                new_tight[new_mod] = (new_tight[new_mod] + val) % MOD

        dp_tight = new_tight
        dp_not_tight = new_not_tight

    # Ответ: все состояния с mod=0
    ans = (dp_tight[0] + dp_not_tight[0]) % MOD
    print(ans)

if __name__ == "__main__":
    solve()
