import sys

def solve():
    input = sys.stdin.readline
    n, K = map(int, input().split())
    S = input().strip()
    MOD = 10**9 + 7

    # Преобразуем в бинарную строку
    R = int(S)
    bin_str = bin(R)[2:]
    L = len(bin_str)
    bits = [int(c) for c in bin_str]

    # Упрощаем размерность DP: удаляем состояние lead, так как lead=1 эквивалентно mod=0
    # Используем два массива для текущей и предыдущей позиции
    prev = [[0] * 2 for _ in range(K)]
    prev[0][1] = 1  # mod=0, tight=1

    # Заранее вычисляем варианты для всех возможных битов
    for pos in range(L):
        curr = [[0] * 2 for _ in range(K)]
        up = bits[pos]

        for mod in range(K):
            tight_ways = prev[mod]
            if not tight_ways[0] and not tight_ways[1]:
                continue

            # Обрабатываем tight=0 и tight=1 отдельно для оптимизации
            # 1. Случай tight=0: можем поставить 0 или 1
            ways0 = tight_ways[0]
            if ways0:
                # Ставим 0
                curr[mod][0] = (curr[mod][0] + ways0) % MOD
                # Ставим 1
                new_mod = (mod + 1) % K
                curr[new_mod][0] = (curr[new_mod][0] + ways0) % MOD

            # 2. Случай tight=1
            ways1 = tight_ways[1]
            if ways1:
                # Если up == 0: можем поставить только 0
                if up == 0:
                    curr[mod][1] = (curr[mod][1] + ways1) % MOD
                # Если up == 1: можем поставить 0 (перестаём быть tight) или 1 (остаёмся tight)
                else:  # up == 1
                    # Ставим 0
                    curr[mod][0] = (curr[mod][0] + ways1) % MOD
                    # Ставим 1
                    new_mod = (mod + 1) % K
                    curr[new_mod][1] = (curr[new_mod][1] + ways1) % MOD

        prev = curr

    # Ответ: все пути с mod=0 (включая x=0, который даёт mod=0 при popcount=0)
    ans = (prev[0][0] + prev[0][1]) % MOD
    print(ans)

if __name__ == "__main__":
    solve()
