import sys
input = sys.stdin.readline
MOD = 10**9 + 7

n, K = map(int, input().split())
S = input().rstrip()

R = int(S)
binR = bin(R)[2:]
L = len(binR)
bits = [int(c) for c in binR]

# Precompute binomial C up to L
C = [[0]*(i+1) for i in range(L+1)]
for i in range(L+1):
    C[i][0] = C[i][i] = 1
    for j in range(1, i):
        C[i][j] = (C[i-1][j-1] + C[i-1][j]) % MOD

# Count numbers < R with popcount ≡ 0 mod K
ans = 0
ones = 0

for pos, b in enumerate(bits):
    if b == 1:
        rem = L - pos - 1
        # add all numbers where we put 0 here and freely choose remaining bits
        for t in range(0, rem+1):
            if (t + ones) % K == 0:
                ans = (ans + C[rem][t]) % MOD
    if b == 1:
        ones += 1

# Include R itself if valid
if ones % K == 0:
    ans = (ans + 1) % MOD

print(ans)
