import sys
sys.setrecursionlimit(10**7)


def count_magic(n):
    s = str(n)
    length = len(s)

    from functools import lru_cache

    @lru_cache(None)
    def dp(pos, num_mod7, sum_mod7, has7, tight, started):
        if pos == length:
            if not started:
                return 0
            if num_mod7 == 0 or has7 or sum_mod7 == 0:
                return 1
            return 0

        limit = int(s[pos]) if tight else 9
        result = 0

        for d in range(limit + 1):
            new_started = started or (d != 0)

            if new_started:
                new_num_mod7 = (num_mod7 * 10 + d) % 7
                new_sum_mod7 = (sum_mod7 + d) % 7
                new_has7 = has7 or (d == 7)
            else:
                new_num_mod7 = 0
                new_sum_mod7 = 0
                new_has7 = False

            new_tight = tight and (d == limit)

            result += dp(
                pos + 1,
                new_num_mod7,
                new_sum_mod7,
                new_has7,
                new_tight,
                new_started,
            )

        return result

    return dp(0, 0, 0, False, True, False)


def solve():
    k = int(sys.stdin.readline().strip())

    lo, hi = 1, 10**20

    while lo < hi:
        mid = (lo + hi) // 2
        if count_magic(mid) >= k:
            hi = mid
        else:
            lo = mid + 1

    print(lo)


if __name__ == "__main__":
    solve()
