import sys
sys.setrecursionlimit(10**7)

def count_magic(N):
    s = str(N)
    n = len(s)

    from functools import lru_cache

    @lru_cache(None)
    def dp(pos, num_mod7, sum_mod7, has7, tight, started):
        if pos == n:
            if not started:
                return 0
            # условие магичности
            if num_mod7 == 0 or has7 or sum_mod7 == 0:
                return 1
            return 0

        limit = int(s[pos]) if tight else 9
        res = 0

        for d in range(0, limit + 1):
            n_started = started or (d != 0)
            if n_started:
                n_num_mod7 = (num_mod7 * 10 + d) % 7
                n_sum_mod7 = (sum_mod7 + d) % 7
                n_has7 = has7 or (d == 7)
            else:
                # число ещё не началось
                n_num_mod7 = 0
                n_sum_mod7 = 0
                n_has7 = False

            n_tight = tight and (d == limit)

            res += dp(pos + 1, n_num_mod7, n_sum_mod7, n_has7, n_tight, n_started)

        return res

    return dp(0, 0, 0, False, True, False)


def solve():
    k = int(sys.stdin.readline().strip())

    lo, hi = 1, 10**20  # достаточно большой диапазон

    while lo < hi:
        mid = (lo + hi) // 2
        if count_magic(mid) >= k:
            hi = mid
        else:
            lo = mid + 1

    print(lo)


if __name__ == "__main__":
    solve()
