import sys
sys.setrecursionlimit(10**7)

def count_magic(N):
    s = str(N)
    n = len(s)

    from functools import lru_cache

    @lru_cache(None)
    def dp(pos, mod7, has7, tight, started):
        if pos == n:
            if not started:
                return 0
            if mod7 == 0 or has7:
                return 1
            return 0

        limit = int(s[pos]) if tight else 9
        res = 0

        for d in range(0, limit + 1):
            n_started = started or (d != 0)
            n_mod7 = (mod7 + d) % 7 if n_started else 0
            n_has7 = has7 or (d == 7 and n_started)
            n_tight = tight and (d == limit)
            res += dp(pos + 1, n_mod7, n_has7, n_tight, n_started)

        return res

    return dp(0, 0, False, True, False)

def solve():
    k = int(sys.stdin.readline().strip())

    lo, hi = 1, 10**20

    while lo < hi:
        mid = (lo + hi) // 2
        if count_magic(mid) >= k:
            hi = mid
        else:
            lo = mid + 1

    print(lo)


if __name__ == "__main__":
    solve()
