def color_cells(rows, cols, colors):
    counts = [0] * colors

    for diag in range(2, rows + cols + 1):
        if diag <= rows + 1:
            cell_count = diag - 1
        else:
            cell_count = rows + cols + 1 - diag

        color_index = (diag - 2) % colors
        counts[color_index] += cell_count

    return counts


import sys

input_data = sys.stdin.read
data = input_data.strip().split()
r = int(data[0])
c = int(data[1])
k = int(data[2])

result = color_cells(r, c, k)

for count in result:
    print(count)

