import sys
def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    it = iter(data)
    t = int(next(it))
    out_lines = []
    for _ in range(t):
        n = int(next(it))
        rects = []
        for __ in range(n):
            x1 = int(next(it));
            y1 = int(next(it))
            x2 = int(next(it));
            y2 = int(next(it))
            rects.append((x1, y1, x2, y2))

        y_low = max(y1 for x1, y1, x2, y2 in rects)
        y_high = min(y2 for x1, y1, x2, y2 in rects)
        horizontal_ok = y_low <= y_high

        x_low = max(x1 for x1, y1, x2, y2 in rects)
        x_high = min(x2 for x1, y1, x2, y2 in rects)
        vertical_ok = x_low <= x_high

        u_min = max(x1 - y2 for x1, y1, x2, y2 in rects)
        u_max = min(x2 - y1 for x1, y1, x2, y2 in rects)
        diag45_ok = u_min <= u_max

        v_min = max(x1 + y1 for x1, y1, x2, y2 in rects)
        v_max = min(x2 + y2 for x1, y1, x2, y2 in rects)
        diag135_ok = v_min <= v_max

        if horizontal_ok or vertical_ok or diag45_ok or diag135_ok:
            out_lines.append("Yes")
        else:
            out_lines.append("No")

    sys.stdout.write("\n".join(out_lines))


if __name__ == "__main__":
    solve()