MOD = 10 ** 9 + 7


def main():
    # Ввод данных
    n_k = input().strip()
    while n_k == "":
        n_k = input().strip()
    n, K = map(int, n_k.split())

    R_str = input().strip()

    # Обработка R=0
    if R_str == '0':
        print(1 if 0 % K == 0 else 0)
        return

    # Переводим R в двоичную
    R_int = int(R_str)
    binary = bin(R_int)[2:]
    length = len(binary)

    # Динамика: dp[остаток][tight]
    dp = [[0, 0] for _ in range(K)]
    dp[0][1] = 1  # начальное состояние

    # Обработка битов
    for bit_char in binary:
        bit = 1 if bit_char == '1' else 0
        new_dp = [[0, 0] for _ in range(K)]

        for rem in range(K):
            # tight=0 (уже меньше)
            val0 = dp[rem][0]
            if val0 > 0:
                # Ставим 0
                new_dp[rem][0] = (new_dp[rem][0] + val0) % MOD
                # Ставим 1
                new_rem = (rem + 1) % K
                new_dp[new_rem][0] = (new_dp[new_rem][0] + val0) % MOD

            # tight=1 (пока совпадает с R)
            val1 = dp[rem][1]
            if val1 > 0:
                # Вариант 0: можно поставить 0 только если bit=1 или bit=0?
                if bit == 1:
                    # Можно поставить 0 (станем tight=0)
                    new_dp[rem][0] = (new_dp[rem][0] + val1) % MOD
                    # Можно поставить 1 (остаёмся tight=1)
                    new_rem = (rem + 1) % K
                    new_dp[new_rem][1] = (new_dp[new_rem][1] + val1) % MOD
                else:  # bit == 0
                    # Можно поставить только 0 (остаёмся tight=1)
                    new_dp[rem][1] = (new_dp[rem][1] + val1) % MOD

        dp = new_dp

    # Ответ
    result = (dp[0][0] + dp[0][1]) % MOD
    print(result)


if __name__ == "__main__":
    main()