import sys


def main():
    # Читаем весь ввод
    data = sys.stdin.read().strip().split()

    if not data:
        return

    # Парсим данные
    m = int(data[0])
    l = int(data[1])
    r = int(data[2])

    # 1. Решето Эратосфена для нахождения наименьших простых делителей
    MAX = r
    spf = list(range(MAX + 1))  # smallest prime factor
    spf[0] = spf[1] = 1

    for i in range(2, int(MAX ** 0.5) + 1):
        if spf[i] == i:  # i простое
            for j in range(i * i, MAX + 1, i):
                if spf[j] == j:
                    spf[j] = i

    # 2. Функция проверки: является ли число нечётно-степенным
    def is_odd_power(num):
        while num > 1:
            p = spf[num]
            cnt = 0
            while num % p == 0:
                num //= p
                cnt += 1
            if cnt % 2 == 0:  # степень чётная
                return False
        return True

    # 3. Массив: good[x] = True если x нечётно-степенное
    good = [False] * (MAX + 1)
    for x in range(l, r + 1):
        good[x] = is_odd_power(x)

    # 4. Ищем последовательность длины m
    count = 0
    for x in range(l, r + 1):
        if good[x]:
            count += 1
            if count == m:
                # Нашли! Выводим m чисел
                start = x - m + 1
                result = ' '.join(str(i) for i in range(start, start + m))
                print(result)
                return
        else:
            count = 0

    # Не нашли
    print(-1)


if __name__ == "__main__":
    main()