import sys


def solve():
    n = int(sys.stdin.readline())
    m = int(sys.stdin.readline())
    k = int(sys.stdin.readline())

    if n > m:
        n, m = m, n

    ans = [0] * k
    max_d = n + m - 2

    # Вспомогательные функции
    def first_in_range(start, end, r):
        """Первое число >= start с остатком r, не больше end"""
        if start > end:
            return None
        mod = start % k
        diff = (r - mod) % k
        first = start + diff
        return first if first <= end else None

    def count_in_range(start, end, r):
        """Количество чисел в [start, end] с остатком r"""
        first = first_in_range(start, end, r)
        if first is None:
            return 0
        return (end - first) // k + 1

    # Для каждого цвета
    for r in range(k):
        total = 0

        # 1. d ∈ [0, n-2], длина = d+1
        end1 = min(n - 2, max_d)
        if end1 >= 0:
            first1 = first_in_range(r, end1, r)
            if first1 is not None:
                cnt1 = count_in_range(first1, end1, r)
                # Сумма длин: sum_{i=0}^{cnt1-1} (first1 + i*k + 1)
                total += cnt1 * (first1 + 1) + k * cnt1 * (cnt1 - 1) // 2

        # 2. d ∈ [n-1, m-2], длина = n
        start2 = max(n - 1, 0)
        end2 = min(m - 2, max_d)
        if start2 <= end2:
            first2 = first_in_range(start2, end2, r)
            if first2 is not None:
                cnt2 = count_in_range(first2, end2, r)
                total += cnt2 * n

        # 3. d ∈ [m-1, max_d], длина = n+m-d-1
        start3 = max(m - 1, 0)
        end3 = max_d
        if start3 <= end3:
            first3 = first_in_range(start3, end3, r)
            if first3 is not None:
                cnt3 = count_in_range(first3, end3, r)
                # Сумма длин: sum_{i=0}^{cnt3-1} (n+m - (first3 + i*k) - 1)
                total += cnt3 * (n + m - first3 - 1) - k * cnt3 * (cnt3 - 1) // 2

        ans[r] = total

    sys.stdout.write('\n'.join(map(str, ans)))


if __name__ == "__main__":
    solve()