import sys


def main():
    input_data = sys.stdin.read().split()
    if not input_data:
        return

    iterator = iter(input_data)
    try:
        num_test_cases = int(next(iterator))
    except StopIteration:
        return

    class ConvexHull:
        def __init__(self, slopes, intercepts, is_lower_hull):
            self.lines = []
            self.is_lower = is_lower_hull
            if is_lower_hull:
                pairs = sorted(zip(slopes, intercepts), key=lambda x: (-x[0], x[1]))
            else:
                pairs = sorted(zip(slopes, intercepts), key=lambda x: (x[0], -x[1]))
            for m, c in pairs:
                if self.lines and self.lines[-1][0] == m:
                    continue

                while len(self.lines) >= 2:
                    m2, c2 = self.lines[-1]
                    m1, c1 = self.lines[-2]
                    if (c2 - c1) * (m2 - m) >= (c - c2) * (m1 - m2):
                        self.lines.pop()
                    else:
                        break
                self.lines.append((m, c))

        def get_val(self, x):
            l, r = 0, len(self.lines) - 1
            best_idx = 0
            while l <= r:
                mid1 = (l + r) // 2
                mid2 = mid1 + 1
                val1 = self.lines[mid1][0] * x + self.lines[mid1][1]
                if mid2 < len(self.lines):
                    val2 = self.lines[mid2][0] * x + self.lines[mid2][1]
                else:
                    best_idx = mid1
                    break
                if self.is_lower:
                    if val1 < val2:
                        best_idx = mid1
                        r = mid1 - 1
                    else:
                        best_idx = mid2
                        l = mid2
                else:
                    if val1 > val2:
                        best_idx = mid1
                        r = mid1 - 1
                    else:
                        best_idx = mid2
                        l = mid2
            return self.lines[best_idx][0] * x + self.lines[best_idx][1]

    for _ in range(num_test_cases):
        try:
            n_str = next(iterator, None)
            if n_str is None:
                break
            n = int(n_str)
        except StopIteration:
            break

        X1 = [0] * n
        Y1 = [0] * n
        X2 = [0] * n
        Y2 = [0] * n

        for i in range(n):
            X1[i] = int(next(iterator))
            Y1[i] = int(next(iterator))
            X2[i] = int(next(iterator))
            Y2[i] = int(next(iterator))

        if max(X1) <= min(X2):
            print("Yes")
            continue

        if max(Y1) <= min(Y2):
            print("Yes")
            continue

        def solve_ternary(x1_arr, y1_arr, x2_arr, y2_arr):
            neg_x1 = [-x for x in x1_arr]
            neg_x2 = [-x for x in x2_arr]
            upper_hull = ConvexHull(neg_x1, y2_arr, is_lower_hull=True)  # Min
            lower_hull = ConvexHull(neg_x2, y1_arr, is_lower_hull=False)  # Max
            left, right = 0.0, 1.0
            for _ in range(40):
                m1 = left + (right - left) / 3
                m2 = right - (right - left) / 3
                val1 = upper_hull.get_val(m1) - lower_hull.get_val(m1)
                val2 = upper_hull.get_val(m2) - lower_hull.get_val(m2)
                if val1 < val2:
                    left = m1
                else:
                    right = m2
            final_k = (left + right) / 2
            final_diff = upper_hull.get_val(final_k) - lower_hull.get_val(final_k)
            return final_diff >= -1e-9

        if solve_ternary(X1, Y1, X2, Y2):
            print("Yes")
            continue

        if solve_ternary(Y1, X1, Y2, X2):
            print("Yes")
            continue

        neg_X1_mapped = [-x for x in X2]
        neg_X2_mapped = [-x for x in X1]

        if solve_ternary(neg_X1_mapped, Y1, neg_X2_mapped, Y2):
            print("Yes")
            continue

        if solve_ternary(Y1, neg_X1_mapped, Y2, neg_X2_mapped):
            print("Yes")
            continue
        print("No")


if __name__ == '__main__':
    main()
