import sys


def main():
    input_data = sys.stdin.read().split()
    if not input_data:
        return

    iterator = iter(input_data)

    try:
        num_test_cases = int(next(iterator))
    except StopIteration:
        return

    for _ in range(num_test_cases):
        try:
            n = int(next(iterator))
        except StopIteration:
            break

        X1 = [0] * n
        Y1 = [0] * n
        X2 = [0] * n
        Y2 = [0] * n

        for i in range(n):
            X1[i] = int(next(iterator))
            Y1[i] = int(next(iterator))
            X2[i] = int(next(iterator))
            Y2[i] = int(next(iterator))

        if max(X1) <= min(X2):
            print("Yes")
            continue

        if max(Y1) <= min(Y2):
            print("Yes")
            continue

        def check_ternary(A, B, C, D):
            left = 0.0
            right = 1.0
            for _ in range(40):
                m1 = left + (right - left) / 3
                m2 = right - (right - left) / 3

                min_ub1 = 1e18
                max_lb1 = -1e18
                for i in range(n):
                    v1 = B[i] - m1 * A[i]
                    v2 = C[i] - m1 * D[i]
                    if v1 < min_ub1: min_ub1 = v1
                    if v2 > max_lb1: max_lb1 = v2
                f1 = min_ub1 - max_lb1

                min_ub2 = 1e18
                max_lb2 = -1e18
                for i in range(n):
                    v1 = B[i] - m2 * A[i]
                    v2 = C[i] - m2 * D[i]
                    if v1 < min_ub2: min_ub2 = v1
                    if v2 > max_lb2: max_lb2 = v2
                f2 = min_ub2 - max_lb2

                if f1 < f2:
                    left = m1
                else:
                    right = m2

            m = (left + right) / 2
            min_ub = 1e18
            max_lb = -1e18
            for i in range(n):
                v1 = B[i] - m * A[i]
                v2 = C[i] - m * D[i]
                if v1 < min_ub: min_ub = v1
                if v2 > max_lb: max_lb = v2

            return (min_ub - max_lb) >= -1e-9
        if check_ternary(X1, Y2, Y1, X2):
            print("Yes")
            continue
        if check_ternary(Y1, X2, X1, Y2):
            print("Yes")
            continue

        NegX1 = [-x for x in X1]
        NegX2 = [-x for x in X2]

        if check_ternary(NegX2, Y2, Y1, NegX1):
            print("Yes")
            continue

        if check_ternary(Y1, NegX1, NegX2, Y2):
            print("Yes")
            continue

        print("No")


if __name__ == '__main__':
    main()