import sys

try:
    sys.set_int_max_str_digits(100000)
except AttributeError:
    pass


def main():
    input_data = sys.stdin.read().split()
    if not input_data:
        return

    n = int(input_data[0])
    K = int(input_data[1])
    R_str = input_data[2]
    MOD = 10 ** 9 + 7

    if R_str == "0":
        print(1)
        return

    R_int = int(R_str)
    R_bin = bin(R_int)[2:]
    L = len(R_bin)
    THRESHOLD = 350
    queries = {}
    prefix_ones = 0

    for i, bit in enumerate(R_bin):
        current_power = L - 1 - i
        if bit == '1':
            target_rem = (-prefix_ones) % K
            queries[current_power] = target_rem
            prefix_ones += 1

    total_ans = 0

    if prefix_ones % K == 0:
        total_ans = 1

    if K <= THRESHOLD:
        dp = [0] * K
        dp[0] = 1
        sorted_powers = sorted(queries.keys())
        max_power = sorted_powers[-1] if sorted_powers else 0
        q_idx = 0
        n_queries = len(sorted_powers)
        for length in range(1, L + 1):
            prev_last = dp[-1]
            dp = [(v + prev_last) % MOD if i == 0 else (v + dp[i - 1]) % MOD for i, v in enumerate(dp)]
            while q_idx < n_queries and sorted_powers[q_idx] == length:
                target = queries[length]
                total_ans = (total_ans + dp[target]) % MOD
                q_idx += 1
            if length > max_power and q_idx >= n_queries:
                break
    else:
        fact = [1] * (L + 1)
        inv = [1] * (L + 1)

        for i in range(2, L + 1):
            fact[i] = (fact[i - 1] * i) % MOD

        inv[L] = pow(fact[L], MOD - 2, MOD)

        for i in range(L - 1, 1, -1):
            inv[i] = (inv[i + 1] * (i + 1)) % MOD

        def nCr_mod(n, r):
            if r < 0 or r > n:
                return 0
            num = fact[n]
            den = (inv[r] * inv[n - r]) % MOD
            return (num * den) % MOD

        for p, target in queries.items():
            current_ways = 0
            start_j = target
            if start_j > p:
                pass
            else:
                for j in range(start_j, p + 1, K):
                    current_ways = (current_ways + nCr_mod(p, j)) % MOD
            total_ans = (total_ans + current_ways) % MOD
    print(total_ans)


if __name__ == '__main__':
    main()
