import sys


def main():
    input_data = sys.stdin.read().split()
    if not input_data:
        return

    n = int(input_data[0])
    K = int(input_data[1])
    R_str = input_data[2]
    MOD = 10 ** 9 + 7

    if R_str == "0":
        print(1)
        return

    R_int = int(R_str)
    R_bin = bin(R_int)[2:]
    L = len(R_bin)
    THRESHOLD = 350
    queries = {}
    prefix_ones = 0
    for i, bit in enumerate(R_bin):
        current_power = L - 1 - i
        if bit == '1':
            target_rem = (K - (prefix_ones % K)) % K
            queries[current_power] = target_rem
            prefix_ones += 1

    total_ans = 0
    if prefix_ones % K == 0:
        total_ans = 1
    if K <= THRESHOLD:
        dp = [0] * K
        dp[0] = 1
        for p in range(L):
            if p in queries:
                target = queries[p]
                total_ans = (total_ans + dp[target]) % MOD
            new_dp = [0] * K
            for r in range(K):
                new_dp[r] = (dp[r] + dp[(r - 1)]) % MOD
            dp = new_dp

    else:
        fact = [1] * (L + 1)
        inv = [1] * (L + 1)

        for i in range(2, L + 1):
            fact[i] = (fact[i - 1] * i) % MOD

        inv[L] = pow(fact[L], MOD - 2, MOD)

        for i in range(L - 1, 1, -1):
            inv[i] = (inv[i + 1] * (i + 1)) % MOD

        def nCr_mod(n, r):
            if r < 0 or r > n:
                return 0
            num = fact[n]
            den = (inv[r] * inv[n - r]) % MOD
            return (num * den) % MOD

        for p, target in queries.items():
            current_ways = 0
            for j in range(target, p + 1, K):
                current_ways = (current_ways + nCr_mod(p, j)) % MOD
            total_ans = (total_ans + current_ways) % MOD
    print(total_ans)


if __name__ == '__main__':
    main()
