import sys


def can_common_line(x1_list, y1_list, x2_list, y2_list):
    n = len(x1_list)

    x_min = max(x1_list)
    x_max = min(x2_list)
    if x_min <= x_max:
        return True

    y_min = max(y1_list)
    y_max = min(y2_list)
    if y_min <= y_max:
        return True

    k_min_up = -10 ** 30
    k_max_up = 10 ** 30
    for i in range(n):
        for j in range(n):
            num = y1_list[i] - y2_list[j]
            den = x2_list[i] - x1_list[j]
            if den > 0:
                val = num / den
                if val > k_min_up:
                    k_min_up = val
            elif den < 0:
                val = num / den
                if val < k_max_up:
                    k_max_up = val
            else:
                if num > 0:
                    return False
    if k_min_up <= k_max_up and k_max_up >= 0:
        k_low = max(k_min_up, 0.0)
        if k_low <= k_max_up:
            return True

    m_min_up = -10 ** 30
    m_max_up = 10 ** 30
    for i in range(n):
        for j in range(n):
            num = y1_list[i] - y2_list[j]
            den = x2_list[j] - x1_list[i]
            if den > 0:
                val = num / den
                if val > m_min_up:
                    m_min_up = val
            elif den < 0:
                val = num / den
                if val < m_max_up:
                    m_max_up = val
            else:
                if num > 0:
                    return False
    if m_min_up <= m_max_up and m_max_up >= 0:
        m_low = max(m_min_up, 0.0)
        if m_low <= m_max_up:
            return True

    return False


def main():
    input_data = sys.stdin.read().strip().split()
    if not input_data:
        return
    t = int(input_data[0])
    idx = 1
    results = []
    for _ in range(t):
        n = int(input_data[idx])
        idx += 1
        x1_list = []
        y1_list = []
        x2_list = []
        y2_list = []
        for __ in range(n):
            x1 = int(input_data[idx]);
            y1 = int(input_data[idx + 1])
            x2 = int(input_data[idx + 2]);
            y2 = int(input_data[idx + 3])
            idx += 4
            x1_list.append(x1)
            y1_list.append(y1)
            x2_list.append(x2)
            y2_list.append(y2)
        if can_common_line(x1_list, y1_list, x2_list, y2_list):
            results.append("Yes")
        else:
            results.append("No")
    sys.stdout.write("\n".join(results))


main()
