import sys
import math

EPS = 1e-9

def check_angle(rects, angle):
    cos_a = math.cos(angle)
    sin_a = math.sin(angle)
    max_L = -10**18
    min_U = 10**18
    for x1, y1, x2, y2 in rects:
        # углы прямоугольника
        vals = [
            cos_a * x1 + sin_a * y1,
            cos_a * x2 + sin_a * y1,
            cos_a * x2 + sin_a * y2,
            cos_a * x1 + sin_a * y2
        ]
        L = min(vals)
        U = max(vals)
        max_L = max(max_L, L)
        min_U = min(min_U, U)
    return max_L <= min_U + EPS

def solve_one(rects):
    # проверка вертикальной
    if max(r[0] for r in rects) <= min(r[2] for r in rects):
        return "Yes"
    # проверка горизонтальной
    if max(r[1] for r in rects) <= min(r[3] for r in rects):
        return "Yes"
    
    # перебор критических углов
    # углы, при которых нормаль перпендикулярна линии, соединяющей две вершины разных прямоугольников
    points = []
    for x1, y1, x2, y2 in rects:
        points.append((x1, y1))
        points.append((x2, y2))
        points.append((x1, y2))
        points.append((x2, y1))
    
    # ограничим количество проверяемых углов
    test_angles = []
    # добавим диагонали
    test_angles.append(math.atan2(1, -1))   # 135°
    test_angles.append(math.atan2(1, 1))    # 45°
    # добавим случайные углы
    for i in range(min(30, len(points))):
        for j in range(i+1, min(30, len(points))):
            dx = points[j][0] - points[i][0]
            dy = points[j][1] - points[i][1]
            if dx == 0 and dy == 0:
                continue
            angle = math.atan2(dy, dx)  # направление линии
            # нормаль перпендикулярна
            norm_angle = angle + math.pi/2
            test_angles.append(norm_angle)
            test_angles.append(norm_angle + math.pi)
    
    # также проверим углы с малым шагом
    for k in range(0, 180, 5):
        test_angles.append(math.radians(k))
    
    # уникальные углы
    test_angles = list(set(test_angles))
    
    for ang in test_angles:
        if check_angle(rects, ang):
            return "Yes"
        if check_angle(rects, ang + math.pi/2):
            return "Yes"
        if check_angle(rects, ang + math.pi/4):
            return "Yes"
    
    # тернарный поиск по углу от 0 до pi
    left, right = 0.0, math.pi
    for _ in range(30):
        m1 = left + (right - left) / 3
        m2 = right - (right - left) / 3
        if check_angle(rects, m1) or check_angle(rects, m2):
            return "Yes"
        # нам нужно min max_L - min_U <= 0, но проще проверять в функции check_angle
        # если ни m1 ни m2 не подходят, сужаем диапазон?
        # но функция может быть немонотонной, поэтому тернарный поиск не гарантирует нахождение.
        # Вместо этого просто проверим равномерно много углов.
        break  # тернарный не подходит для немонотонной
    
    # финальная проверка по плотной сетке
    for ang in [math.radians(d) for d in range(0, 180, 2)]:
        if check_angle(rects, ang):
            return "Yes"
    
    return "No"

def main():
    input = sys.stdin.read
    data = input().split()
    t = int(data[0])
    idx = 1
    out = []
    for _ in range(t):
        n = int(data[idx]); idx += 1
        rects = []
        for __ in range(n):
            x1 = int(data[idx]); y1 = int(data[idx+1])
            x2 = int(data[idx+2]); y2 = int(data[idx+3])
            idx += 4
            rects.append((x1, y1, x2, y2))
        out.append(solve_one(rects))
    sys.stdout.write("\n".join(out))

if __name__ == "__main__":
    main()
