import sys

def check_vertical(rects):
    max_x1 = max(r[0] for r in rects)
    min_x2 = min(r[2] for r in rects)
    return max_x1 <= min_x2

def check_horizontal(rects):
    max_y1 = max(r[1] for r in rects)
    min_y2 = min(r[3] for r in rects)
    return max_y1 <= min_y2

def check_diag1(rects):  # 45 deg: x - y + c = 0
    max_val = max(r[0] - r[3] for r in rects)  # x1 - y2
    min_val = min(r[2] - r[1] for r in rects)  # x2 - y1
    return max_val <= min_val

def check_diag2(rects):  # 135 deg: x + y + c = 0
    max_val = max(r[0] + r[1] for r in rects)  # x1 + y1
    min_val = min(r[2] + r[3] for r in rects)  # x2 + y2
    return max_val <= min_val

def sign_combinations(rects, sa, sb):
    # sa, sb in {1, -1}
    max_min_val = -10**18
    min_max_val = 10**18
    for x1, y1, x2, y2 in rects:
        if sa == 1:
            min_x, max_x = x1, x2
        else:
            min_x, max_x = x2, x1
        if sb == 1:
            min_y, max_y = y1, y2
        else:
            min_y, max_y = y2, y1
        min_val = sa * min_x + sb * min_y
        max_val = sa * max_x + sb * max_y
        max_min_val = max(max_min_val, min_val)
        min_max_val = min(min_max_val, max_val)
    return max_min_val <= min_max_val

def check_fixed_signs(rects):
    for sa in (1, -1):
        for sb in (1, -1):
            if sign_combinations(rects, sa, sb):
                return True
    return False

def solve_one(rects):
    if check_vertical(rects):
        return "Yes"
    if check_horizontal(rects):
        return "Yes"
    if check_diag1(rects):
        return "Yes"
    if check_diag2(rects):
        return "Yes"
    if check_fixed_signs(rects):
        return "Yes"
    return "No"

def main():
    import sys
    input = sys.stdin.read
    data = input().split()
    t = int(data[0])
    idx = 1
    out = []
    for _ in range(t):
        n = int(data[idx]); idx += 1
        rects = []
        for __ in range(n):
            x1 = int(data[idx]); y1 = int(data[idx+1])
            x2 = int(data[idx+2]); y2 = int(data[idx+3])
            idx += 4
            rects.append((x1, y1, x2, y2))
        out.append(solve_one(rects))
    sys.stdout.write("\n".join(out))

if __name__ == "__main__":
    main()
