import sys

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    it = iter(data)
    T = int(next(it))
    out_lines = []
    for _ in range(T):
        n = int(next(it))
        x1_list, y1_list, x2_list, y2_list = [], [], [], []
        for __ in range(n):
            x1 = int(next(it))
            y1 = int(next(it))
            x2 = int(next(it))
            y2 = int(next(it))
            x1_list.append(x1)
            y1_list.append(y1)
            x2_list.append(x2)
            y2_list.append(y2)
        
        ok = False
        
        # vertical
        if max(x1_list) <= min(x2_list):
            ok = True
        
        # horizontal
        if max(y1_list) <= min(y2_list):
            ok = True
        
        # 45 degrees (slope 1)
        max_u = max(x1 - y2 for x1, y2 in zip(x1_list, y2_list))
        min_u = min(x2 - y1 for x2, y1 in zip(x2_list, y1_list))
        if max_u <= min_u:
            ok = True
        
        # 135 degrees (slope -1)
        max_p = max(x1 + y1 for x1, y1 in zip(x1_list, y1_list))
        min_p = min(x2 + y2 for x2, y2 in zip(x2_list, y2_list))
        if max_p <= min_p:
            ok = True
        
        out_lines.append("Yes" if ok else "No")
    
    sys.stdout.write("\n".join(out_lines))

if __name__ == "__main__":
    solve()
