import sys

MOD = 10**8 + 7

def bin_str_from_decimal(s):
    digits = list(map(int, s))
    bits = []
    while any(d != 0 for d in digits):
        rem = 0
        new_digits = []
        for d in digits:
            rem = rem * 10 + d
            new_digits.append(rem // 2)
            rem %= 2
        bits.append(str(rem))
        # удаляем ведущие нули
        start = 0
        while start < len(new_digits) and new_digits[start] == 0:
            start += 1
        digits = new_digits[start:]
    if not bits:
        return "0"
    bits.reverse()
    return ''.join(bits)

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n = int(data[0])
    K = int(data[1])
    R = data[2]

    if R == '0':
        # только число 0
        print(1 % MOD)
        return

    bin_R = bin_str_from_decimal(R)
    m = len(bin_R)

    if K > m:
        # только popcount = 0
        print(1 % MOD)
        return

    # dp[mod][tight]
    dp = [[0, 0] for _ in range(K)]
    dp[0][1] = 1

    for i, ch in enumerate(bin_R):
        bit = 1 if ch == '1' else 0
        ndp = [[0, 0] for _ in range(K)]
        for r in range(K):
            # tight = 1
            val_tight = dp[r][1]
            if val_tight:
                if bit == 0:
                    # можем поставить только 0, остаёмся в tight=1
                    ndp[r][1] = (ndp[r][1] + val_tight) % MOD
                else:  # bit == 1
                    # ставим 0 -> tight=0, остаток r
                    ndp[r][0] = (ndp[r][0] + val_tight) % MOD
                    # ставим 1 -> tight=1, остаток (r+1)%K
                    ndp[(r + 1) % K][1] = (ndp[(r + 1) % K][1] + val_tight) % MOD
            # tight = 0
            val_loose = dp[r][0]
            if val_loose:
                # можем поставить 0
                ndp[r][0] = (ndp[r][0] + val_loose) % MOD
                # можем поставить 1
                ndp[(r + 1) % K][0] = (ndp[(r + 1) % K][0] + val_loose) % MOD
        dp = ndp

    ans = (dp[0][0] + dp[0][1]) % MOD
    print(ans)

if __name__ == "__main__":
    solve()
