import sys

MOD = 10**8 + 7

def binary_string_from_decimal(s):
    # s is decimal string
    # convert to binary string (big-endian, first char = most significant bit)
    digits = list(map(int, s))
    bits = []
    while digits:
        remainder = 0
        new_digits = []
        for d in digits:
            remainder = remainder * 10 + d
            new_digits.append(remainder // 2)
            remainder %= 2
        bits.append(str(remainder))
        # remove leading zeros in new_digits
        digits = []
        leading = True
        for nd in new_digits:
            if nd != 0:
                leading = False
            if not leading:
                digits.append(nd)
    bits.reverse()
    if not bits:
        return "0"
    return ''.join(bits)

def solve():
    input_data = sys.stdin.read().strip().split()
    if not input_data:
        return
    n = int(input_data[0])
    K = int(input_data[1])
    R = input_data[2]

    bin_R = binary_string_from_decimal(R)
    m = len(bin_R)

    if K > m:
        # only possible popcount 0
        print(1 % MOD)
        return

    # dp[r][tight]
    dp = [[0, 0] for _ in range(K)]
    dp[0][1] = 1  # start at pos 0, remainder 0, tight=1

    for pos in range(m):
        bit = int(bin_R[pos])
        new_dp = [[0, 0] for _ in range(K)]
        for r in range(K):
            for tight in (0, 1):
                val = dp[r][tight]
                if val == 0:
                    continue
                # try put 0
                max_bit = bit if tight else 1
                for b in (0, 1):
                    if b > max_bit:
                        continue
                    new_tight = tight and (b == bit)
                    new_r = (r + b) % K
                    new_dp[new_r][new_tight] = (new_dp[new_r][new_tight] + val) % MOD
        dp = new_dp

    # answer: all numbers with r=0, tight=0 or tight=1 (all <= R)
    result = (dp[0][0] + dp[0][1]) % MOD
    print(result)

if __name__ == "__main__":
    solve()
