import sys

MOD = 10**8 + 7

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n = int(data[0])
    K = int(data[1])
    R_dec = data[2]
    
    # Переводим R в двоичное представление
    R_int = int(R_dec)
    # Но R может быть огромным (длина до 20000 десятичных цифр),
    # int() упадёт. Нужно преобразовывать по-другому.
    # Для больших R лучше работать со строкой.
    # Переведём R в двоичную строку без преобразования в int:
    
    # Функция для перевода десятичной строки в двоичную
    def dec_to_bin(s):
        # s - десятичная строка
        bits = []
        while s != '0':
            # вычислим остаток от деления на 2
            remainder = 0
            new_s = []
            for ch in s:
                remainder = remainder * 10 + int(ch)
                new_s.append(str(remainder // 2))
                remainder %= 2
            bits.append(str(remainder))
            # убрать ведущие нули в new_s
            s = ''.join(new_s).lstrip('0') or '0'
        return ''.join(bits[::-1]) if bits else '0'
    
    bin_str = dec_to_bin(R_dec)
    L = len(bin_str)
    
    # DP: dp[pos][c][tight]
    # pos от 0 до L, c от 0..K-1, tight 0/1
    dp = [[[0, 0] for _ in range(K)] for _ in range(L + 1)]
    dp[0][0][1] = 1  # начальное состояние: 0 бит, 0 единиц, tight=1
    
    for pos in range(L):
        max_bit = 1 if bin_str[pos] == '1' else 0
        for c in range(K):
            for tight in (0, 1):
                val = dp[pos][c][tight]
                if val == 0:
                    continue
                # пробуем поставить 0
                bit = 0
                new_tight = tight and (bit == max_bit)
                dp[pos + 1][c][new_tight] = (dp[pos + 1][c][new_tight] + val) % MOD
                # пробуем поставить 1
                bit = 1
                if tight and bit > max_bit:
                    continue
                new_tight = tight and (bit == max_bit)
                new_c = (c + 1) % K
                dp[pos + 1][new_c][new_tight] = (dp[pos + 1][new_c][new_tight] + val) % MOD
    
    # Ответ: все числа <= R с popcount % K == 0, кроме x=0
    ans = (dp[L][0][0] + dp[L][0][1] - 1) % MOD
    print(ans)

if __name__ == "__main__":
    solve()
