MOD = 10**8 + 7

def solve():
    import sys
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n = int(data[0])
    K = int(data[1])
    R_str = data[2]
    
    # Двоичное представление R
    R_int = 0
    for ch in R_str:
        R_int = (R_int * 10 + int(ch))  # можно и так, но для больших n лучше работать со строкой
    # Но для больших n (20000 цифр) int(R_str) будет медленно, лучше переводить в двоичную строку по-другому
    # Воспользуемся встроенной поддержкой больших чисел:
    R_int = int(R_str)
    binary_R = bin(R_int)[2:]  # строка из '0' и '1'
    L = len(binary_R)
    
    if K > L:
        # popcount может быть от 0 до L, кратных K нет, кроме 0, но popcount=0 только у x=0, не подходит
        print(0)
        return
    
    # DP: dp[mod][tight]
    dp = [[0, 0] for _ in range(K)]
    dp[0][1] = 1  # начинаем: пустой префикс, 0 единиц, tight=1
    
    for pos in range(L):
        new_dp = [[0, 0] for _ in range(K)]
        bit_R = int(binary_R[pos])
        for mod in range(K):
            for tight in range(2):
                val = dp[mod][tight]
                if val == 0:
                    continue
                limit = bit_R if tight else 1
                for bit in range(limit + 1):
                    new_tight = tight and (bit == limit)
                    new_mod = (mod + bit) % K
                    new_dp[new_mod][new_tight] = (new_dp[new_mod][new_tight] + val) % MOD
        dp = new_dp
    
    # Ответ: все числа от 0 до R с popcount % K == 0, кроме 0
    ans = (dp[0][0] + dp[0][1] - 1) % MOD
    print(ans)

if __name__ == "__main__":
    solve()
