def solve():
    import sys

    MOD = 10**8 + 7

    data = sys.stdin.read().strip().split()
    if not data:
        return
    n = int(data[0])
    K = int(data[1])
    R_str = data[2]

    # Преобразуем R в двоичную строку
    R_int = int(R_str)
    # Но R может быть огромным, n до 30000, int(R_str) будет слишком большое,
    # нужно преобразовывать по-другому, без перевода в int.
    # Бинарные цифры R получим делением на 2 в столбик.
    
    # Преобразование десятичной строки в бинарную по алгоритму деления
    def dec_to_bin(s):
        bits = []
        while s != '0':
            # s: decimal string
            # вычислим s % 2
            last_digit = int(s[-1])
            if last_digit % 2 == 1:
                bits.append('1')
            else:
                bits.append('0')
            # s = s // 2
            new_s = []
            carry = 0
            for ch in s:
                carry = carry * 10 + int(ch)
                new_s.append(str(carry // 2))
                carry %= 2
            # убрать ведущие нули
            s = ''.join(new_s).lstrip('0')
            if s == '':
                s = '0'
        bits.reverse()
        return bits
    
    bits_R = dec_to_bin(R_str)  # список '0'/'1'
    L = len(bits_R)
    
    # dp[mod][tight]
    dp = [[0, 0] for _ in range(K)]
    dp[0][1] = 1  # начальное состояние: pos=0, mod=0, tight=1
    
    for pos in range(L):
        ndp = [[0, 0] for _ in range(K)]
        bitR = int(bits_R[pos])
        for mod in range(K):
            for tight in (0, 1):
                cur = dp[mod][tight]
                if cur == 0:
                    continue
                # ставим 0
                if tight == 1:
                    if bitR == 0:
                        ndp[mod][1] = (ndp[mod][1] + cur) % MOD
                    else:  # bitR == 1
                        ndp[mod][0] = (ndp[mod][0] + cur) % MOD
                else:  # tight == 0
                    ndp[mod][0] = (ndp[mod][0] + cur) % MOD
                # ставим 1
                if tight == 1:
                    if bitR == 1:
                        ndp[(mod + 1) % K][1] = (ndp[(mod + 1) % K][1] + cur) % MOD
                    # если bitR == 0, нельзя ставить 1 при tight=1
                else:  # tight == 0
                    ndp[(mod + 1) % K][0] = (ndp[(mod + 1) % K][0] + cur) % MOD
        dp = ndp
    
    # Ответ: все числа от 0 до R включительно
    # dp[mod][tight] для mod=0
    ans = (dp[0][0] + dp[0][1]) % MOD
    print(ans)

if name == "__main__":
    solve()
