MOD = 10**8 + 7

def solve():
    import sys
    input_data = sys.stdin.read().strip().split()
    if not input_data:
        return
    n = int(input_data[0])
    K = int(input_data[1])
    R_str = input_data[2]
    
    # Преобразуем R в двоичную строку без ведущих нулей
    R_int = int(R_str)
    binary_R = bin(R_int)[2:]  # строка из '0' и '1', старший бит первый
    m = len(binary_R)
    
    # DP[pos][cnt][tight]
    # pos от 0 до m
    from functools import lru_cache
    
    None
    def dp(pos, cnt_mod, tight):
        if pos == m:
            # Конец числа
            return 1 if cnt_mod == 0 else 0
        
        limit = int(binary_R[pos]) if tight else 1
        total = 0
        for bit in range(limit + 1):
            next_tight = tight and (bit == limit)
            next_cnt = (cnt_mod + bit) % K
            total += dp(pos + 1, next_cnt, next_tight)
            total %= MOD
        return total
    
    # Находим количество чисел 1..R, у которых popcount % K == 0
    ans = dp(0, 0, True)
    
    # Вычитаем x=0 (если оно учтено, но у нас x>0, так что не нужно вычитать)
    # dp считает все числа от 0 до R, нам нужно только >0.
    # Проверим, учитывает ли dp(0,0,True) число 0?
    # Число 0: все биты 0, cnt_mod=0, tight=True, длина m, pos=m => 1 способ.
    # Поэтому ans содержит число 0. Вычтем его.
    # Но нужно аккуратно: если R=0, то ответ 0.
    if R_int == 0:
        print(0)
    else:
        # Вычитаем 1, если cnt_mod для 0 равен 0 (а это так)
        ans = (ans - 1) % MOD
        print(ans)

if __name__ == "__main__":
    solve()
