import sys

MOD = 10**9 + 7

def solve():
    input_data = sys.stdin.read().strip().split()
    if not input_data:
        return
    n = int(input_data[0])
    K = int(input_data[1])
    R_str = input_data[2]
    
    # Преобразуем R в двоичную строку
    R_int = int(R_str)
    binary_R = bin(R_int)[2:]
    L = len(binary_R)
    
    # Предподсчитаем факториалы и обратные факториалы для C(n, k) по модулю MOD
    max_n = L + 5
    fact = [1] * (max_n + 1)
    inv_fact = [1] * (max_n + 1)
    
    for i in range(2, max_n + 1):
        fact[i] = fact[i-1] * i % MOD
    
    def mod_pow(a, b):
        res = 1
        while b:
            if b & 1:
                res = res * a % MOD
            a = a * a % MOD
            b »= 1
        return res
    
    inv_fact[max_n] = mod_pow(fact[max_n], MOD-2)
    for i in range(max_n-1, -1, -1):
        inv_fact[i] = inv_fact[i+1] * (i+1) % MOD
    
    def comb(n, k):
        if k < 0 or k > n:
            return 0
        return fact[n] * inv_fact[k] % MOD * inv_fact[n-k] % MOD
    
    ans = 0
    pref_ones = 0  # количество единиц в уже обработанном префиксе
    
    # Идём по битам слева направо
    for i in range(L):
        if binary_R[i] == '1':
            # Позиция, где мы ставим 0 вместо 1
            free = L - i - 1  # свободные младшие позиции
            # Нужно: (pref_ones + t) % K == 0
            # t ≡ (-pref_ones) mod K
            r = (-pref_ones) % K
            
            # Суммируем C(free, t) для t = r, r+K, r+2K, ... <= free
            t = r
            while t <= free:
                ans = (ans + comb(free, t)) % MOD
                t += K
            
            pref_ones += 1
    
    # В конце проверяем само число R
    if pref_ones % K == 0:
        ans = (ans + 1) % MOD
    
    print(ans)

if name == "__main__":
    solve()
