def solve():
    import sys
    input = sys.stdin.read
    data = input().split()
    
    m = int(data[0])
    l = int(data[1])
    r = int(data[2])
    
    # Решето для нахождения наименьшего простого делителя
    n = r
    spf = list(range(n + 1))  # smallest prime factor
    for i in range(2, int(n**0.5) + 1):
        if spf[i] == i:
            for j in range(i * i, n + 1, i):
                if spf[j] == j:
                    spf[j] = i
    
    # Функция проверки, является ли x нечётно-степенным
    def is_odd_power(x):
        while x > 1:
            p = spf[x]
            cnt = 0
            while x % p == 0:
                x //= p
                cnt += 1
            if cnt % 2 == 0:
                return False
        return True
    
    # Массив: 1 если нечётно-степенное, иначе 0
    good = [0] * (r - l + 1)
    for i in range(l, r + 1):
        if is_odd_power(i):
            good[i - l] = 1
    
    # Скользящее окно
    count = 0
    for i in range(r - l + 1):
        if i >= m:
            if good[i - m]:
                count -= 1
        if good[i]:
            count += 1
        if i >= m - 1 and count == m:
            start = i - m + 1 + l
            print(" ".join(str(start + j) for j in range(m)))
            return
    
    print(-1)

if __name__ == "__main__":
    solve()
