import math

def is_prime(n):
    """Проверка числа на простоту."""
    if n <= 1:
        return False
    if n <= 3:
        return True
    if n % 2 == 0 or n % 3 == 0:
        return False
    i = 5
    while i * i <= n:
        if n % i == 0 or n % (i + 2) == 0:
            return False
        i += 6
    return True

def prime_factors(n):
    """Возвращает список простых делителей числа n."""
    factors = []
    # Проверяем делимость на 2
    while n % 2 == 0:
        factors.append(2)
        n //= 2
    # Проверяем делимость на нечетные числа
    for i in range(3, int(math.sqrt(n)) + 1, 2):
        while n % i == 0:
            factors.append(i)
            n //= i
    # Если n осталось больше 2, то оно само является простым числом
    if n > 2:
        factors.append(n)
    return factors

def is_odd_power_number(n):
    """Проверяет, является ли число нечётно-степенным."""
    factors = prime_factors(n)
    factor_count = {}
    for factor in factors:
        if factor in factor_count:
            factor_count[factor] += 1
        else:
            factor_count[factor] = 1
    # Проверяем, что все степени простых делителей нечётные
    for count in factor_count.values():
        if count % 2 == 0:
            return False
    return True

def main():
    # Чтение входного файла
    with open('input.txt', 'r') as file:
        numbers = [int(line.strip()) for line in file]
    
    # Фильтрация нечётно-степенных чисел
    odd_power_numbers = [num for num in numbers if is_odd_power_number(num)]
    
    # Запись в выходной файл
    with open('output.txt', 'w') as file:
        for num in odd_power_numbers:
            file.write(f"{num}\n")

if __name__ == "__main__":
    main()
