import sys
input = sys.stdin.readline

MAXR = 10**6

# Решето для поиска "нечётно-степенных" чисел
is_odd_power = [True] * (MAXR + 1)
is_odd_power[0] = False

# Нам нужно знать, есть ли в факторизации простая в чётной степени >= 2
# Эквивалентно: число не является квадратом какого-то числа,
# у которого есть хотя бы один простой множитель в чётной степени.
# Удобнее идти по всем квадратам простых и их степеням 4, 6, ... (то есть p^(2k)).
spf = list(range(MAXR + 1))
for i in range(2, int(MAXR ** 0.5) + 1):
    if spf[i] == i:
        for j in range(i * i, MAXR + 1, i):
            if spf[j] == j:
                spf[j] = i

# помечаем все числа, у которых какая-либо простая входит в чётной степени ≥ 2
for p in range(2, MAXR + 1):
    if spf[p] == p:  # простое
        p2 = p * p
        power = p2
        while power <= MAXR:
            for x in range(power, MAXR + 1, power):
                is_odd_power[x] = False
            power *= p2

m = int(input())
queries = [tuple(map(int, input().split())) for _ in range(m)]

out_lines = []
for l, r in queries:
    best_len = 0
    best_start = -1

    cur_len = 0
    cur_start = -1

    for x in range(l, r + 1):
        if is_odd_power[x]:
            if cur_len == 0:
                cur_start = x
            cur_len += 1
            if cur_len > best_len:
                best_len = cur_len
                best_start = cur_start
        else:
            cur_len = 0

    if best_len == 0:
        out_lines.append("-1")
    else:
        seq = [str(best_start + i) for i in range(best_len)]
        out_lines.append(" ".join(seq))

print("\n".join(out_lines))
