def solve():
    import sys
    sys.setrecursionlimit(10**7)
    input = sys.stdin.read
    data = input().split()
    
    m = int(data[0])
    l = int(data[1])
    r = int(data[2])
    
    # r может быть большим, но разница r-l+1 может быть до 10^6 по условиям подзадач
    # Хотя в максимальном случае r до 10^8, но l близко к r, поэтому длина отрезка небольшая.
    # Но если m большое, то r-l+1 тоже большое, но в условии задачи не сказано, что l и r близки.
    # Поэтому будем осторожны с памятью.
    
    # Максимальное число, которое нам нужно проверять: r (если ищем последовательность, начинающуюся в l)
    # Но нам нужно проверить все числа от l до r
    # Если r-l+1 очень велико (10^8), то это может быть слишком много по памяти.
    # Но ограничение по памяти 256 МБ, можно попробовать.
    
    # Создадим массив для минимального простого делителя до r+1
    n = r
    if n < 2:
        n = 2
    limit = n + 1
    spf = list(range(limit))  # smallest prime factor
    
    # Решето Эратосфена с сохранением минимального простого делителя
    for i in range(2, int(n**0.5) + 1):
        if spf[i] == i:  # i простое
            for j in range(i*i, limit, i):
                if spf[j] == j:
                    spf[j] = i
    
    # Теперь массив good длины (r-l+1), где good[i] = 1, если число l+i нечётно-степенное
    length = r - l + 1
    good = [1] * length  # изначально все хорошие
    
    for i in range(length):
        num = l + i
        # факторизуем num через spf
        n_temp = num
        while n_temp > 1:
            p = spf[n_temp]
            cnt = 0
            while n_temp % p == 0:
                n_temp //= p
                cnt += 1
            if cnt % 2 == 0:
                good[i] = 0
                break
    
    # Теперь ищем m подряд идущих единиц в good
    consecutive = 0
    start = -1
    for i in range(length):
        if good[i] == 1:
            consecutive += 1
            if consecutive == m:
                start = i - m + 1
                break
        else:
            consecutive = 0
    
    if start == -1:
        print(-1)
    else:
        first_num = l + start
        result = [first_num + i for i in range(m)]
        print(' '.join(map(str, result)))

if name == "__main__":
    solve()
