import sys
import math

def mobius_sieve(n: int):
    """Возвращает значения μ(1..n) и список простых до n."""
    mu = [1] * (n + 1)
    is_comp = [False] * (n + 1)
    primes = []

    for i in range(2, n + 1):
        if not is_comp[i]:
            primes.append(i)
            mu[i] = -1            # простое
        for p in primes:
            v = i * p
            if v > n:
                break
            is_comp[v] = True
            if i % p == 0:
                mu[v] = 0         # квадрат простого в разложении
                break
            else:
                mu[v] = -mu[i]
    return mu

def sq_free_prefix(x: int, mu):
    """Количество квадрат‑свободных чисел на отрезке [1, x]."""
    if x <= 0:
        return 0
    limit = int(math.isqrt(x))
    res = 0
    for i in range(1, limit + 1):
        res += mu[i] * (x // (i * i))
    return res

def solve():
    data = sys.stdin.read().strip().split()
    if not 
        return
    m = int(data[0])
    # дальше идут k запросов, их количество явно дано во второй строке
    # (по условию: во второй строке задано число k)
    # поэтому читаем его отдельно
    # формат ввода: m, затем k, затем k строк l r
    k = int(data[1])
    pairs = []
    idx = 2
    max_r = 0
    for _ in range(k):
        l = int(data[idx])
        r = int(data[idx + 1])
        idx += 2
        pairs.append((l, r))
        if r > max_r:
            max_r = r

    # нам нужен μ до sqrt(max_r)
    max_i = int(math.isqrt(max_r))
    mu = mobius_sieve(max_i)

    out_lines = []
    for l, r in pairs:
        ans = sq_free_prefix(r, mu) - sq_free_prefix(l - 1, mu)
        out_lines.append(str(ans))
    sys.stdout.write("\n".join(out_lines))

if name == "__main__":
    solve()
