def solve():
    import sys
    data = list(map(int, sys.stdin.read().split()))
    m, l, r = data
    
    # Построим SPF (smallest prime factor) до r
    N = r
    spf = list(range(N + 1))
    for i in range(2, int(N**0.5) + 1):
        if spf[i] == i:
            step = i
            start = i * i
            for j in range(start, N + 1, step):
                if spf[j] == j:
                    spf[j] = i

    # Проверка нечётности степеней простых множителей
    def is_odd_power(x):
        if x <= 1:
            return False
        while x > 1:
            p = spf[x]
            cnt = 0
            while x % p == 0:
                x //= p
                cnt += 1
            if cnt % 2 == 0:
                return False
        return True

    # Строим массив флагов для [l, r]
    size = r - l + 1
    flags = [0] * size
    for i, val in enumerate(range(l, r + 1)):
        if is_odd_power(val):
            flags[i] = 1

    # Ищем окно длины m
    if m <= size:
        window = sum(flags[:m])
        if window == m:
            print(l, l + m)
            return

        for i in range(m, size):
            window += flags[i] - flags[i - m]
            if window == m:
                start = l + i - m + 1
                print(start, start + m)
                return

    print(-1)
