def kth_magic_number_fast(k):
    # Числа, удовлетворяющие условиям, образуют периодическую последовательность
    # Период LCM(7, 10) = 70
    
    # Посчитаем, сколько магических чисел в одном периоде
    magic_in_period = 0
    magic_numbers_in_period = []
    
    for i in range(1, 71):  # от 1 до 70
        if i % 7 == 0 or i % 10 == 7:
            magic_in_period += 1
            magic_numbers_in_period.append(i)
    
    # Вычислим количество полных периодов
    full_periods = (k - 1) // magic_in_period
    
    # Найдем остаток
    remainder = (k - 1) % magic_in_period
    
    # Искомое число
    return full_periods * 70 + magic_numbers_in_period[remainder]

if __name__ == "__main__":
    k = int(input())
    print(kth_magic_number_fast(k))
