def count_magic(n: int) -> int:
    """Количество магических чисел от 1 до n включительно"""
    div7 = n // 7
    if n < 7:
        return div7  # end7 и both = 0
    end7 = (n - 7) // 10 + 1
    both = (n - 7) // 70 + 1
    return div7 + end7 - both

def kth_magic_number(k: int) -> int:
    if k == 0:
        return 0  # по условию k ≥ 1
    left, right = 1, 7 * k
    while left < right:
        mid = (left + right) // 2
        if count_magic(mid) >= k:
            right = mid
        else:
            left = mid + 1
    return left

def main():
    k = int(input().strip())
    print(kth_magic_number(k))

if name == "main":
    main()
