import sys

def sum_arithmetic(first, last, step, a0, d):
    # Сумма a_i для i = first, first+step, ..., last
    # где a_i = a0 + d*i
    if first > last:
        return 0
    n_terms = (last - first) // step + 1
    last_term = a0 + d * last
    return n_terms * (a0 + d * first + last_term) // 2

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n, m, k = map(int, data[:3])
    
    total = n + m
    A = min(n, m)
    B = max(n, m)
    
    cnt = [0] * k
    
    for idx in range(k):  # цвет idx соответствует idx+1 в выводе
        r = (idx + 2) % k  # остаток для s: s ≡ r (mod k)
        if r == 0:
            r = k
        # Теперь r в 1..k
        
        # 1) Интервал возрастания: s = 2..A+1, len = s-1
        start1 = max(2, r)
        if start1 % k != r % k:
            start1 += (k - (start1 % k - r) % k)
        end1 = A + 1
        if start1 <= end1:
            # len(s) = s-1, т.е. a0 = start1-1, d = k
            # sum_{t} (start1-1 + k*t) по t от 0 до T
            # Пересчитаем через формулу арифметической прогрессии
            terms1 = (end1 - start1) // k + 1
            last1 = start1 + (terms1 - 1) * k
            # Сумма len = sum(s-1) = sum(s) - terms1
            sum_s = terms1 * (start1 + last1) // 2
            cnt[idx] += sum_s - terms1
        
        # 2) Интервал плато: s = A+2 .. B+1, len = A
        start2 = max(A + 2, r)
        if start2 % k != r % k:
            start2 += (k - (start2 % k - r) % k)
        end2 = B + 1
        if start2 <= end2:
            terms2 = (end2 - start2) // k + 1
            cnt[idx] += terms2 * A
        
        # 3) Интервал убывания: s = B+2 .. total, len = total - s + 1
        start3 = max(B + 2, r)
        if start3 % k != r % k:
            start3 += (k - (start3 % k - r) % k)
        end3 = total
        if start3 <= end3:
            terms3 = (end3 - start3) // k + 1
            last3 = start3 + (terms3 - 1) * k
            # len(s) = total - s + 1
            # sum len = terms3*(total+1) - sum(s)
            sum_s3 = terms3 * (start3 + last3) // 2
            cnt[idx] += terms3 * (total + 1) - sum_s3
    
    print(' '.join(str(cnt[i]) for i in range(k)))

if __name__ == "__main__":
    solve()
