import sys

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n, m, k = map(int, data[:3])
    
    cnt = [0] * k
    
    for s in range(2, n + m + 1):
        low = max(1, s - m)
        high = min(n, s - 1)
        length = high - low + 1
        if length > 0:
            color = (s - 2) % k  # color 0..k-1 для цвета 1..k
            cnt[color] += length
    
    # Переводим в цвета 1..k
    print(' '.join(str(cnt[i]) for i in range(k)))

if __name__ == "__main__":
    solve()
