import math

def prime_factors_fast(n, sieve_limit=1000000):
    factors = []
    
   
    if n <= sieve_limit:
        primes = generate_primes_sieve(int(math.isqrt(n)) + 1)
    else:

        primes = None
    
    if primes:

        for p in primes:
            if p * p > n:
                break
            while n % p == 0:
                factors.append(p)
                n //= p
    else:

        while n % 2 == 0:
            factors.append(2)
            n //= 2
        
        while n % 3 == 0:
            factors.append(3)
            n //= 3
        
        d = 5
        increment = [2, 4]
        i = 0
        sqrt_n = int(math.isqrt(n))
        
        while d <= sqrt_n:
            while n % d == 0:
                factors.append(d)
                n //= d
                sqrt_n = int(math.isqrt(n))
            
            d += increment[i]
            i = 1 - i
    
    if n > 1:
        factors.append(n)
    
    return factors

def generate_primes_sieve(limit):

    sieve = [True] * limit
    sieve[0:2] = [False, False]
    
    for i in range(2, int(math.isqrt(limit)) + 1):
        if sieve[i]:
            sieve[i*i:limit:i] = [False] * len(range(i*i, limit, i))
    
    return [i for i, is_prime in enumerate(sieve) if is_prime]
m = int(input())
l, r = input().split()
l = int(l)
r = int(r)
list_ = []

for i in range(l, r+1):
    nums = prime_factors_fast(i)
    yes = 0
    for j in nums:

        if nums.count(j) % 2 == 0:
            yes = 1   
            break
        else:
            yes = 0
    if yes == 0:
        list_.append(i)

x = 0
if len(list_) >= m:
    for i in range(len(list_)-m+1):
        if (list_[i]+list_[i+m-1])*(list_[i+m-1]-list_[i]+1) // 2 == m*list_[i]+(m)*(m-1)//2:
            print(*list_[i:m+i])
            x = 1
            break
        
            
    if x == 0:
        print(-1)
else:
    print(-1)


