import math

def prime_factors(n):
    factors = []
    
    # Обработка четных чисел
    while n % 2 == 0:
        factors.append(2)
        n //= 2
    
    # Обработка числа 3
    while n % 3 == 0:
        factors.append(3)
        n //= 3
    
    # Проверяем делители вида 6k ± 1, начиная с 5
    # Все простые числа больше 3 имеют вид 6k ± 1
    d = 5
    increment = [2, 4]  # шаги: 5+2=7, 7+4=11, 11+2=13, 13+4=17 и т.д.
    i = 0
    
    # Проверяем только до квадратного корня из n
    sqrt_n = int(math.isqrt(n))  # isqrt более эффективен чем sqrt
    while d <= sqrt_n:
        while n % d == 0:
            factors.append(d)
            n //= d
            sqrt_n = int(math.isqrt(n))  # пересчитываем корень при изменении n
        
        # Переходим к следующему кандидату вида 6k ± 1
        d += increment[i]
        i = 1 - i  # чередуем 2 и 4
    
    # Если после всех проверок осталось простое число > 1
    if n > 1:
        factors.append(n)
    
    return factors

m = int(input())
l, r = input().split()
l = int(l)
r = int(r)
list_ = []

for i in range(l, r+1):
    nums = prime_factors(i)
    yes = 0
    for j in nums:

        if nums.count(j) % 2 == 0:
            yes = 1   
            break
        else:
            yes = 0
    if yes == 0:
        list_.append(i)

x = 0
if len(list_) >= m:
    for i in range(len(list_)-m+1):
        if (list_[i]+list_[i+m-1])*(list_[i+m-1]-list_[i]+1) // 2 == m*list_[i]+(m)*(m-1)//2:
            print(*list_[i:m+i])
            x = 1
            break
        
            
    if x == 0:
        print(-1)
else:
    print(-1)


