import sys
from bisect import bisect_right

sys.setrecursionlimit(2000)


def solve():
    input_data = sys.stdin.read().split()
    if not input_data:
        return

    iterator = iter(input_data)
    try:
        T_str = next(iterator)
        T = int(T_str)
    except StopIteration:
        return

    for _ in range(T):
        try:
            n = int(next(iterator))
        except StopIteration:
            break

        R_x1 = [0] * n
        R_y1 = [0] * n
        R_x2 = [0] * n
        R_y2 = [0] * n

        max_x1 = -float('inf')
        min_x2 = float('inf')

        for i in range(n):
            x1 = int(next(iterator))
            y1 = int(next(iterator))
            x2 = int(next(iterator))
            y2 = int(next(iterator))
            R_x1[i] = x1
            R_y1[i] = y1
            R_x2[i] = x2
            R_y2[i] = y2

            if x1 > max_x1: max_x1 = x1
            if x2 < min_x2: min_x2 = x2

        if max_x1 <= min_x2:
            print("Yes")
            continue

        def build_upper_hull(lines):
            lines.sort(key=lambda x: (x[0], x[1]))

            unique_lines = []
            if not lines: return [], []

            curr_m, curr_c = lines[0]
            for i in range(1, len(lines)):
                m, c = lines[i]
                if m == curr_m:
                    curr_c = c
                else:
                    unique_lines.append((curr_m, curr_c))
                    curr_m, curr_c = m, c
            unique_lines.append((curr_m, curr_c))

            hull = []
            for m, c in unique_lines:
                while len(hull) >= 2:
                    m2, c2 = hull[-1]
                    m1, c1 = hull[-2]

                    x_new = (c2 - c) / (m - m2)
                    x_old = (c1 - c2) / (m2 - m1)

                    if x_new <= x_old:
                        hull.pop()
                    else:
                        break
                hull.append((m, c))

            breakpoints = [-float('inf')]
            for i in range(1, len(hull)):
                m1, c1 = hull[i - 1]
                m2, c2 = hull[i]
                x = (c1 - c2) / (m2 - m1)
                breakpoints.append(x)

            return breakpoints, hull

        def build_lower_hull(lines):
            # min(kx + b) == -max(-kx - b)
            neg_lines = [(-m, -c) for m, c in lines]
            bps, h = build_upper_hull(neg_lines)
            res_hull = [(-m, -c) for m, c in h]
            return bps, res_hull

        def get_val(k, bps, hull):
            idx = bisect_right(bps, k) - 1
            m, c = hull[idx]
            return m * k + c

        def solve_range(k_min, k_max, l_lines, r_lines):
            bps_L, hull_L = build_upper_hull(l_lines)
            bps_R, hull_R = build_lower_hull(r_lines)

            if k_min == 0:
                if get_val(0, bps_L, hull_L) <= get_val(0, bps_R, hull_R):
                    return True

            low = float(k_min)
            high = float(k_max)
            found = False

            for _ in range(60):
                m1 = low + (high - low) / 3
                m2 = high - (high - low) / 3

                gap1 = get_val(m1, bps_L, hull_L) - get_val(m1, bps_R, hull_R)
                gap2 = get_val(m2, bps_L, hull_L) - get_val(m2, bps_R, hull_R)

                if gap1 <= 1e-9 or gap2 <= 1e-9:
                    found = True
                    break

                if gap1 < gap2:
                    high = m2
                else:
                    low = m1

            if found or (get_val(low, bps_L, hull_L) - get_val(low, bps_R, hull_R) <= 1e-9):
                return True
            return False

        l_lines_pos = []
        r_lines_pos = []
        for i in range(n):
            l_lines_pos.append((-R_x2[i], R_y1[i]))
            r_lines_pos.append((-R_x1[i], R_y2[i]))

        if solve_range(0, 2e9, l_lines_pos, r_lines_pos):
            print("Yes")
            continue

        l_lines_neg = []
        r_lines_neg = []
        for i in range(n):
            l_lines_neg.append((-R_x1[i], R_y1[i]))
            r_lines_neg.append((-R_x2[i], R_y2[i]))

        if solve_range(-2e9, 0, l_lines_neg, r_lines_neg):
            print("Yes")
        else:
            print("No")


if __name__ == '__main__':
    solve()