import sys

sys.setrecursionlimit(3000)


def solve():
    input_data = sys.stdin.read().split()
    if not input_data:
        return

    iterator = iter(input_data)
    try:
        t_str = next(iterator)
        T = int(t_str)
    except StopIteration:
        return

    out = []

    for _ in range(T):
        try:
            n = int(next(iterator))
        except StopIteration:
            break

        X1 = [0] * n
        Y1 = [0] * n
        X2 = [0] * n
        Y2 = [0] * n

        max_x1 = -1
        min_x2 = 2000000000

        for i in range(n):
            x1 = int(next(iterator))
            y1 = int(next(iterator))
            x2 = int(next(iterator))
            y2 = int(next(iterator))

            X1[i] = x1
            Y1[i] = y1
            X2[i] = x2
            Y2[i] = y2

            if x1 > max_x1: max_x1 = x1
            if x2 < min_x2: min_x2 = x2

        if max_x1 <= min_x2:
            out.append("Yes")
            continue

        def solve_half(x1, y1, x2, y2):
            lines_R = []
            lines_L = []
            for i in range(n):
                lines_R.append((-x1[i], y2[i]))
                lines_L.append((x2[i], -y1[i]))

            def get_hull(lines):
                lines.sort(key=lambda x: (-x[0], x[1]))

                hull = []
                for m, c in lines:
                    if hull and hull[-1][0] == m:
                        continue

                    while len(hull) >= 2:
                        m1, c1 = hull[-2]
                        m2, c2 = hull[-1]
                        if (c2 - c1) * (m2 - m) >= (c - c2) * (m1 - m2):
                            hull.pop()
                        else:
                            break
                    hull.append((m, c))


                active_idx = 0
                while active_idx < len(hull) - 1:
                    m1, c1 = hull[active_idx]
                    m2, c2 = hull[active_idx + 1]
                    if c2 - c1 <= 0:
                        active_idx += 1
                    else:
                        break

                final_lines = hull[active_idx:]

                points = [(0, 1)]
                for i in range(len(final_lines) - 1):
                    m1, c1 = final_lines[i]
                    m2, c2 = final_lines[i + 1]
                    points.append((c2 - c1, m1 - m2))

                return final_lines, points

            hull_R, pts_R = get_hull(lines_R)
            hull_L, pts_L = get_hull(lines_L)

            all_points = pts_R + pts_L
            all_points.sort(key=lambda p: p[0] / p[1])

            idx_R = 0
            idx_L = 0
            n_R = len(pts_R)
            n_L = len(pts_L)

            def check_val(n_val, d_val, mR, cR, mL, cL):
                return (mR + mL) * n_val + (cR + cL) * d_val >= 0

            for p in all_points:
                n_val, d_val = p
                val = n_val / d_val

                while idx_R < n_R - 1:
                    pn, pd = pts_R[idx_R + 1]
                    if pn / pd <= val + 1e-12:
                        idx_R += 1
                    else:
                        break

                while idx_L < n_L - 1:
                    pn, pd = pts_L[idx_L + 1]
                    if pn / pd <= val + 1e-12:
                        idx_L += 1
                    else:
                        break

                mR, cR = hull_R[idx_R]
                mL, cL = hull_L[idx_L]

                if check_val(n_val, d_val, mR, cR, mL, cL):
                    return True

            if hull_R and hull_L:
                if hull_R[-1][0] + hull_L[-1][0] > 0:
                    return True

            return False

        if solve_half(X1, Y1, X2, Y2):
            out.append("Yes")
        else:
            X1_n = [-x for x in X2]
            X2_n = [-x for x in X1]
            if solve_half(X1_n, Y1, X2_n, Y2):
                out.append("Yes")
            else:
                out.append("No")

    sys.stdout.write('\n'.join(out) + '\n')


if __name__ == '__main__':
    solve()