import sys
import bisect

sys.setrecursionlimit(3000)


def solve():
    input_data = sys.stdin.read().split()
    if not input_data:
        return
    iterator = iter(input_data)

    try:
        t_str = next(iterator)
        T = int(t_str)
    except StopIteration:
        return

    out = []

    for _ in range(T):
        try:
            n_str = next(iterator)
            n = int(n_str)
        except StopIteration:
            break

        x1 = [0] * n
        y1 = [0] * n
        x2 = [0] * n
        y2 = [0] * n

        min_x2 = 2000000000
        max_x1 = -1

        for i in range(n):
            X1 = int(next(iterator))
            Y1 = int(next(iterator))
            X2 = int(next(iterator))
            Y2 = int(next(iterator))

            x1[i] = X1
            y1[i] = Y1
            x2[i] = X2
            y2[i] = Y2

            if X1 > max_x1: max_x1 = X1
            if X2 < min_x2: min_x2 = X2

        if max_x1 <= min_x2:
            out.append("Yes")
            continue

        def build_lower_hull(lines):
            lines.sort(key=lambda x: (-x[0], x[1]))

            hull = []
            for m, c in lines:
                if hull and hull[-1][0] == m:
                    continue

                while len(hull) >= 2:
                    m1, c1 = hull[-2]
                    m2, c2 = hull[-1]
                    m3, c3 = m, c

                    if (c2 - c1) * (m2 - m3) >= (c3 - c2) * (m1 - m2):
                        hull.pop()
                    else:
                        break
                hull.append((m, c))

            res = []
            if not hull:
                return res

            res.append((0.0, hull[0][0], hull[0][1]))

            for i in range(1, len(hull)):
                m1, c1 = hull[i - 1]
                m2, c2 = hull[i]
                intersect = (c2 - c1) / (m1 - m2)
                if intersect < 0: intersect = 0.0
                res.append((intersect, m2, c2))

            return res

        def eval_hull(hull, k):
            if not hull: return 0
            keys = [h[0] for h in hull]
            idx = bisect.bisect_right(keys, k) - 1
            if idx < 0: idx = 0
            m, c = hull[idx][1], hull[idx][2]
            return m * k + c


        lines_U = []
        lines_mL = []
        for i in range(n):
            lines_U.append((-x1[i], y2[i]))
            lines_mL.append((x2[i], -y1[i]))

        hull_U = build_lower_hull(lines_U)
        hull_mL = build_lower_hull(lines_mL)

        def func_pos(k):
            return eval_hull(hull_U, k) + eval_hull(hull_mL, k)

        def check_ternary(func):
            low = 0.0
            high = 2000000000.0
            for _ in range(70):
                m1 = low + (high - low) / 3
                m2 = high - (high - low) / 3
                if func(m1) < func(m2):
                    low = m1
                else:
                    high = m2
            return func(low)

        if check_ternary(func_pos) >= -1e-5:
            out.append("Yes")
            continue


        lines_U_neg = []
        lines_mL_neg = []
        for i in range(n):
            lines_U_neg.append((x2[i], y2[i]))
            lines_mL_neg.append((-x1[i], -y1[i]))

        hull_U_neg = build_lower_hull(lines_U_neg)
        hull_mL_neg = build_lower_hull(lines_mL_neg)

        def func_neg(k):
            return eval_hull(hull_U_neg, k) + eval_hull(hull_mL_neg, k)

        if check_ternary(func_neg) >= -1e-5:
            out.append("Yes")
            continue

        out.append("No")

    print('\n'.join(out))


if __name__ == '__main__':
    solve()